<?php
/*--------------------------------------------------------------------
 AppendPropertiesModelConfiguration.php 2020-2-20
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Database\Configurations;


use InvalidArgumentException;

/**
 * Class AppendPropertiesModelConfiguration
 * @package Gambio\Shop\SellingUnit\Database\Configurations
 */
class AppendPropertiesModelConfiguration
{
    /**
     * @var bool
     */
    protected $appendModelConfiguration;
    
    
    /**
     * AppendPropertiesModelConfiguration constructor.
     *
     * @param null $value
     */
    public function __construct($value = null)
    {
        if (!defined('APPEND_PROPERTIES_MODEL') && $value === null) {
    
            throw new InvalidArgumentException('APPEND_PROPERTIES_MODEL constant needs to be set'
                                               . ' or the value needs to be transmitted as argument in the '
                                               . 'constructor of ' . static::class);
        }
        
        $this->appendModelConfiguration = $value ?? (bool)APPEND_PROPERTIES_MODEL;
    }
    
    
    /**
     * @return bool
     */
    public function value(): bool
    {
        return $this->appendModelConfiguration;
    }
}